<?php
//__NM__staff__NM__FUNCTION__NM__//

function GetNextTicketMessageID($ticket_id){

	$str_sql = "select count(ticketMessageid) from ticketmessage
		    where ticketid = $ticket_id";
	sc_lookup(dataset,$str_sql);
	$int_result  = {dataset}[0][0]+1;
	return $int_result;
}

function CloseTicket($ticket_id){

	if($ticket_id == ''){ return false; }
	
	$str_update = "update ticket set statusid = 'CLOSED'
	               where ticketid = $ticket_id";
	sc_exec_sql($str_update);
	
	return true;
}

function TransferTicket($ticket_id,$new_ownerid){

	if($ticket_id == ''){ return false; }
	
	if($new_ownerid == ''){
		return false;	
	}
	
	$str_update = "update ticket 
	                  set ownerid = $new_ownerid,
	                      statusid = 'ASSIGNED'
	               where ticketid = $ticket_id";
	sc_exec_sql($str_update);	
	
	return true;
}

function UpdateTicketStatus($ticket_id,$status_id = 'REPLIED'){
	
	if($ticket_id == ''){ return false; }

	$str_update = "update ticket set Statusid = '$status_id'
	               where ticketid = $ticket_id";
	sc_exec_sql($str_update);
	
	return true;
}

function GetTicketSubject($ticket_id){

	if($ticket_id == ''){ return false; }
	
	$str_sql = "SELECT subject FROM ticket where ticketid = $ticket_id";
	sc_lookup(dataset,$str_sql);
	
	return {dataset}[0][0];
}

function GetTicketStatus($ticket_id){

	if($ticket_id == ''){ return false; }
	
	$str_sql = "SELECT statusid FROM ticket where ticketid = $ticket_id";
	sc_lookup(dataset,$str_sql);
	
	return {dataset}[0][0];
}

function GetTicketRating($ticket_id)
{
	if($ticket_id == ''){ return false; }
	
	$str_sql = "SELECT customerrating FROM ticket where ticketid = $ticket_id";
	sc_lookup(dataset,$str_sql);
	
	return {dataset}[0][0];   
}


function GetOperatorName($staffid){

	if($staffid == ''){ return false; }
	
	$str_sql = "SELECT staffname FROM staff 
	            WHERE staffid = $staffid";
	            
	sc_lookup(dataset,$str_sql);
	
	return {dataset}[0][0];
}

function GetCustomerTicket($ticket_id){

	if($ticket_id == ''){ return false; }
	
	$str_sql = "SELECT customerid FROM ticket where ticketid = $ticket_id";
	sc_lookup(dataset,$str_sql);
	
	return {dataset}[0][0];
}

function GetCustomerEmail($customerid){

	if($customerid== ''){ return false; }
	
	$str_sql = "SELECT customeremail FROM customer where customerid = $customerid";
	sc_lookup(dataset,$str_sql);
	
	return {dataset}[0][0];
}

function GetCustomerName($customerid){

	if($customerid== ''){ return false; }
	
	$str_sql = "SELECT customername FROM customer where customerid = $customerid";
	sc_lookup(dataset,$str_sql);
	
	return {dataset}[0][0];
}

function SetTicketOwner($ticket_id,$staffid){

	if($ticket_id == '' || $staffid == ''){ return false; }
	
	$str_sql = "SELECT ownerid FROM ticket 
	            WHERE ticketid = $ticket_id";
	            
	sc_lookup(dataset,$str_sql);
	
	if({dataset}[0][0] == false){
	
		$str_update = "update ticket set ownerid = $staffid
		               where ticketid = $ticket_id";
		sc_exec_sql($str_update);	
		return true;
	}
}

function LoadStaff($staffid){

	if($staffid == ''){ return false; }

	$str_sql = "SELECT
			staffid,
			staffname,
			staffemail,
			staffpassword,
			adminflag,
			stafflanguage,
			signature
		    FROM
			staff
		    WHERE
			staffemail = '$staffid'";

	sc_lookup(dataset,$str_sql);
	
	if(empty({dataset}[0][0])){ return false; }
	
	$arr_staff = array();
	$arr_staff['staffid']      = (!empty({dataset}[0][0]))?{dataset}[0][0]:'';
	$arr_staff['staffname']    = (!empty({dataset}[0][1]))?{dataset}[0][1]:'';
	$arr_staff['staffemail']   = (!empty({dataset}[0][2]))?{dataset}[0][2]:'';
	$arr_staff['staffpassword']= (!empty({dataset}[0][3]))?{dataset}[0][3]:'';
	$arr_staff['adminflag']    = (!empty({dataset}[0][4]))?{dataset}[0][4]:'';
	$arr_staff['stafflanguage']     = (!empty({dataset}[0][5]))?{dataset}[0][5]:'';
	$arr_staff['signature']    = (!empty({dataset}[0][6]))?{dataset}[0][6]:'-------------------<br />'.$arr_staff['staffname'];

	$str_sql = "SELECT categoryid FROM staff_categories
                    WHERE staff_staffid = ".$arr_staff['staffid'];
	sc_lookup(dscategories,$str_sql);

	$str_categories = '';
	foreach({dscategories} as $arr_categories){
		$str_categories.= $arr_categories[0].","; 
	}
	$str_categories = substr($str_categories,0,strlen($str_categories)-1);
	
	$arr_staff['categories']     = ($str_categories!='')?$str_categories:'null';
		
	return $arr_staff;
}



function LoadSettings(){

	$str_sql = "SELECT
			smtpserver,
			smtpuser,
			smtppassword,
			assigmentmode,
			publicticketsopening,
			definedparameters,
			broadcastmessages,
			defaultpriority,
			smtpsecurityflag,
			smtpport,
			urltrackingscreen,
			defaultlanguage,
			urlconfirmationscreen,
			emailaccount,
			sys_version
		   FROM
			systemsettings
		   WHERE
			id = 1";
			
	sc_lookup(dataset,$str_sql);
	
	$arr_load = array();
	$arr_load['smtpserver']            = (!empty({dataset}[0][0]))?{dataset}[0][0]:'';
	$arr_load['smtpuser']              = (!empty({dataset}[0][1]))?{dataset}[0][1]:'';
	$arr_load['smtppassword']          = (!empty({dataset}[0][2]))?{dataset}[0][2]:'';
	$arr_load['assigmentmode']         = (!empty({dataset}[0][3]))?{dataset}[0][3]:'';
	$arr_load['publicticketsopening']  = (!empty({dataset}[0][4]))?{dataset}[0][4]:'';
	$arr_load['definedparameters']     = (!empty({dataset}[0][5]))?{dataset}[0][5]:'';
	$arr_load['broadcastmessages']     = (!empty({dataset}[0][6]))?{dataset}[0][6]:'';
	$arr_load['defaultpriority']       = (!empty({dataset}[0][7]))?{dataset}[0][7]:'';
	$arr_load['smtpsecurityflag']      = (!empty({dataset}[0][8]))?{dataset}[0][8]:'';
	$arr_load['smtpport']              = (!empty({dataset}[0][9]))?{dataset}[0][9]:'';
	$arr_load['urltrackingscreen']     = (!empty({dataset}[0][10]))?{dataset}[0][10]:'';
	$arr_load['defaultlanguage']       = (!empty({dataset}[0][11]))?{dataset}[0][11]:'en_us;en_us';
	$arr_load['urlconfirmationscreen'] = (!empty({dataset}[0][12]))?{dataset}[0][12]:'';	
	$arr_load['emailaccount'] 	   = (!empty({dataset}[0][13]))?{dataset}[0][13]:'';	
	$arr_load['version'] 	  	   = (!empty({dataset}[0][14]))?{dataset}[0][14]:'';	

	$_SESSION['ticketsettings'] = $arr_load;	

}

function getCustomerByEmail($customer_email){

	if(empty($customer_email)){ return false; }

	$str_sql = "SELECT customerid, customername, customerpassword
                    FROM customer where customeremail = '$customer_email'";

	sc_lookup(dataset,$str_sql);
	
	$arr_customer = array();
	$arr_customer['customerid']      = (!empty({dataset}[0][0]))?{dataset}[0][0]:'';
	$arr_customer['customername']    = (!empty({dataset}[0][1]))?{dataset}[0][1]:'';
	$arr_customer['customerpassword']= (!empty({dataset}[0][2]))?{dataset}[0][2]:'';

	return $arr_customer;
	
}
// returns an staff array with name and password by staffid 
function getStaffById($staff_id){

	if(empty($staff_id)){ return false; }

	$str_sql = "SELECT staffid, staffname, staffemail
                    FROM staff where staffid = '$staff_id'";

	sc_lookup(dataset,$str_sql);
	
	$arr_staff = array();
	$arr_staff['staffid']      = (!empty({dataset}[0][0]))?{dataset}[0][0]:'';
	$arr_staff['staffname']    = (!empty({dataset}[0][1]))?{dataset}[0][1]:'';
	$arr_staff['staffemail']   = (!empty({dataset}[0][2]))?{dataset}[0][2]:'';

	return $arr_staff;
}

// returns an staff array with name and password by email
function getStaffByEmail($staff_email){

	if(empty($staff_email)){ return false; }

	$str_sql = "SELECT staffid, staffname, staffpassword
                    FROM staff where staffemail = '$staff_email'";

	sc_lookup(dataset,$str_sql);
	
	$arr_staff = array();
	$arr_staff['staffid']      = (!empty({dataset}[0][0]))?{dataset}[0][0]:'';
	$arr_staff['staffname']    = (!empty({dataset}[0][1]))?{dataset}[0][1]:'';
	$arr_staff['staffpassword']= (!empty({dataset}[0][2]))?{dataset}[0][2]:'';

	return $arr_staff;
}

function SetTrackingId($ticket, $mode='')
{
	//update the ticket tracking and returns the url for 
	//tracking it. 
	
	$trk_id = strtoupper(substr(md5($ticket),0,10));
	sc_exec_sql("UPDATE ticket SET tickettrack = '$trk_id' WHERE ticketid = $ticket");

	if($mode == 'RELATIVE') {
	
	$url_tracking = '../ctrl_tracking_tickets/ctrl_tracking_tickets.php'. '?v_trackingid=' . $trk_id;

	} else {
	
	$url_tracking = $_SESSION['TicketSettings']['UrlTrackingScreen'] . '?v_trackingid=' . $trk_id;
	
	}
	return($url_tracking);
}


function GetTrackingId($ticket)
{
		
	$trk_id = strtoupper(substr(md5($ticket),0,10));
	return($trk_id);
}


function VersionDemo(){

	$arr_load = (!empty($_SESSION['TicketSettings']))?$_SESSION['TicketSettings']:false;
	if($arr_load == false){
		sc_error_message({lang_error_blocked_demo});
	}
	$bl_version = $arr_load['Version'];
	
	if($bl_version == 'demo'){
		sc_error_message({lang_error_blocked_demo});
	} 

}

function DefinedParameters(){

	$definedParameters  = (!empty($_SESSION['TicketSettings']['DefinedParameters']))?
				$_SESSION['TicketSettings']['DefinedParameters']:false;

	if($definedParameters != 'Y'){
		sc_redir('form_systemsettings.php');
	}

}

function scTicketStart(){
	$str_file = '../../../devel/conf/scriptcase/sc_tickets_start';
	
	if(is_file($str_file)){
	
		$str_sql = "SELECT
				strftime('%Y', ticketdate) as Year,
				strftime('%m', ticketdate) as Month
			    FROM
			        ticket
			    order by    
			        ticketdate desc";
		sc_lookup(dataset,$str_sql);
		
		$last_month  = {dataset}[0][1];
		$last_year   = {dataset}[0][0];
		
		if($last_year == date('Y') && $last_month < date('m')){
		
			$diff = date('m') - $last_month;
			
			$str_sql = "update ticket set
			ticketdate = datetime(ticketdate ,'+$diff month'),
			ticketlastupdate = datetime(ticketlastupdate,'+$diff month')";
			sc_exec_sql($str_sql);
			
			$str_sql = "update ticketmessage set
			ticketdate = datetime(ticketdate ,'+$diff month')";
			sc_exec_sql($str_sql);
			
		}
		elseif($last_year < date('Y')){
			$diff = date('Y') - $last_year;
			
			$str_sql = "update ticket set
			ticketdate = datetime(ticketdate ,'+$diff year'),
			ticketlastupdate = datetime(ticketlastupdate,'+$diff year')";
			sc_exec_sql($str_sql);
			
			$str_sql = "update ticketmessage set
			ticketdate = datetime(ticketdate ,'+$diff year')";
			sc_exec_sql($str_sql);
		
		}
		unlink($str_file);
	
	}

}

function M_Warning($str_title, $str_message, $int_left=100, $int_top=100, $int_width=400,$action='RETURN'){

	$str_possition = "position:absolute; left:".$int_left."px; top:".$int_top."px; ";
 	if($action == 'RETURN') $str_possition = '';
 
 $str_html = "
	<table id='scwarningid' cellspacing='0' cellpading='0' 
	 style='".$str_possition." border:1px solid #d1dceb; width:".$int_width."px; z-index:300; background-color:#FFFFFF' >
	<tr>
	  <td background='../_lib/img/bgGrid.png' style='font-size:12px; font-weight:bolder;' >
	  <!-- <a href='#' onclick=\"document.getElementById('scwarningid').style.display='none';\">
	    <img src='../_lib/img/grp__NM__ok.gif' border='0' /></a> -->
	  ".$str_title."
	  </td>
	</tr>
	<tr>
	  <td style='font-size:12px; padding:10px'>".$str_message."  
	  </td>
	</tr>
	</table>
"; 
 
 	if($action == 'RETURN') return $str_html;
 	else echo $str_html;
 
 
 }


?>