<?php
/**
 * Template scriptcase.
 *
 * Modulo de Seguranca.
 *
 * @package     Template
 * @subpackage  Scriptcase
 * @creation    2009/04/14
 * @copyright   NetMake Solucoes em Informatica
 * @author      Juliano Mesquita dos Santos <juliano@netmake.com.br>
 *
 * $Id: body_security_module_step_associar.tpl.php,v 1.5 2012-01-25 13:52:25 vinicius Exp $
 */

/* Protecao contra hacks */
if (!defined('SC_LOCKED_VERSION_8976') || ('CARREGADO4536' != SC_LOCKED_VERSION_8976)) {
    die('<br /><span style="font-weight: bold">Fatal error</span>: ' .
        'invalid access to system file.');
}

$arr_tables = $this->GetVar('arr_tables');

?>

<div class="ui grid">
    <div class="left floated twelve wide column" style="text-align: left;">

        <h3 class="ui header"><?php echo nm_get_text_lang("['assoc']"); ?></h3>
    </div>

    <div class="right floated two wide column"
         style="display: flex; flex-direction: row; justify-content: flex-end; align-items: center;">
        <?php echo $this->GetVar('block_image_help'); ?>
    </div>
</div>
<div class="ui divider"></div>

<div class="ui top attached tabular menu">
    <a class="active item" id='usr_aba'
       data-tab="usr"><label><?php echo nm_get_text_lang("['usr']['title']"); ?></label></a>
    <a class="item" id='grp_aba' data-tab="grp"><label><?php echo nm_get_text_lang("['grp']['title']"); ?></label></a>
    <a class="item" id='app_aba' data-tab="app"><label><?php echo nm_get_text_lang("['app']['title']"); ?></label></a>
    <a class="item" id='usr_grp_aba'
       data-tab="usr_grp"><label><?php echo nm_get_text_lang("['usr']['title']") . " / " . nm_get_text_lang("['grp']['title']"); ?></label></a>
    <a class="item" id='usr_app_aba'
       data-tab="usr_app"><label><?php echo nm_get_text_lang("['usr']['title']") . " / " . nm_get_text_lang("['app']['title']"); ?></label></a>
    <a class="item" id='grp_app_aba'
       data-tab="grp_app"><label><?php echo nm_get_text_lang("['grp']['title']") . " / " . nm_get_text_lang("['app']['title']"); ?></label></a>

    <?php if ($_SESSION['nm_session']['module_security']['profile']['tabela_logged'] == 'S'): ?>
        <a class="item" id='logged_aba'
           data-tab="logged"><label><?php echo nm_get_text_lang("['logged']['title']"); ?></label></a>
    <?php endif; ?>

    <?php if ($_SESSION['nm_session']['module_security']['profile']['tabela_social'] == 'S'): ?>
        <a class="item" id='social_aba'
           data-tab="social"><label><?php echo nm_get_text_lang("['social']['title']"); ?></label></a>
    <?php endif; ?>
    <a class="item" id='settings_aba'
       data-tab="settings"><label><?php echo nm_get_text_lang("['settings']['title']"); ?></label></a>
</div>

<div class="ui bottom attached active tab segment" data-tab="usr" id="usr">
    <div class="ui">
        <div class="ui form">
            <div class="fields two">
                <div class='field'>

                    <label><?php echo nm_get_text_lang("['table']"); ?></label>


                    <select class='select_tables search ui fluid dropdown selection' name='usr[table]'
                            onChange="ajaxGetFields(this.value, 'usr');">
                        <option value=""></option>
                        <?php
                        foreach ($arr_tables as $table) {
                            echo "<option value='" . $table . "'>" . $table . "</option>";
                        }
                        ?>
                    </select>

                </div>
                <div class='field'>

                    <label><?php echo nm_get_text_lang("['login']"); ?></label>


                    <select name='usr[login]' class='select_fields search ui fluid dropdown selection'>

                    </select>

                </div>
            </div>
            <div class="fields two">
                <div class='field'>

                    <label><?php echo nm_get_text_lang("['pass']"); ?></label>


                    <select name='usr[pswd]' class='select_fields search ui fluid dropdown selection'>

                    </select>

                </div>
                <div class='field'>

                    <label><?php echo nm_get_text_lang("['name']"); ?></label>


                    <select name='usr[name]' class='select_fields search ui fluid dropdown selection'>

                    </select>

                </div>
            </div>
            
            <div class="fields two">
                <div class='field'>

                    <label><?php echo nm_get_text_lang("['phone']['title']"); ?></label>


                    <select name='usr[phone]' class='select_fields search ui fluid dropdown selection'>

                    </select>

                </div>
                <div class='field'>

                    <label><?php echo nm_get_text_lang("['role']['title']"); ?></label>


                    <select name='usr[role]' class='select_fields search ui fluid dropdown selection'>

                    </select>

                </div>
            </div>
            
            <div class="fields two">
                <div class='field'>

                    <label><?php echo nm_get_text_lang("['email']"); ?></label>


                    <select name='usr[email]' class='select_fields search ui fluid dropdown selection'>

                    </select>

                </div>
                <div class='field'>

                    <label><?php echo nm_get_text_lang("['active']"); ?></label>


                    <select name='usr[active]' class='select_fields search ui fluid dropdown selection'>

                    </select>

                </div>
            </div>
            <div class="fields two">
                <div class='field'>

                    <label><?php echo nm_get_text_lang("['actvation_code']"); ?></label>


                    <select name='usr[activation_code]' class='select_fields search ui fluid dropdown selection'>

                    </select>

                </div>
                <div class='field'>

                    <label><?php echo nm_get_text_lang("['priv_admin']"); ?></label>


                    <select name='usr[priv_admin]' class='select_fields search ui fluid dropdown selection'>

                    </select>

                </div>
            </div>

            <div class="fields two">
                <div class='field'>

                    <label><?php echo nm_get_text_lang("['2fa']['title']"); ?></label>


                    <select name='usr[mfa]' class='select_fields search ui fluid dropdown selection'>

                    </select>

                </div>
                <div class='field'>

                    <label><?php echo nm_get_text_lang("['picture']['title']"); ?></label>


                    <select name='usr[picture]' class='select_fields search ui fluid dropdown selection'>

                    </select>

                </div>
            </div>

            <div class="fields two">
                <div class='field'>

                    <label><?php echo nm_get_text_lang("['pswd_last_updated']['title']"); ?></label>


                    <select name='usr[pswd_last_updated]' class='select_fields search ui fluid dropdown selection'>

                    </select>

                </div>
            </div>
            <div class="fields two">
                <div class='field'>

                    <label><?php echo nm_get_text_lang("['mfa_last_updated']['title']"); ?></label>


                    <select name='usr[mfa_last_updated]' class='select_fields search ui fluid dropdown selection'>

                    </select>

                </div>
            </div>

        </div>
    </div>
</div>
<div class="ui bottom attached tab segment" data-tab="app" id="app">
    <div class="ui">
        <div class="ui form">

            <div class="fields two">
                <div class='field'>

                    <label><?php echo nm_get_text_lang("['table']"); ?></label>


                    <select class='select_tables search ui fluid dropdown selection' name='app[table]'
                            onChange="ajaxGetFields(this.value, 'app');">
                        <option value=""></option>
                        <?php
                        foreach ($arr_tables as $table) {
                            echo "<option value='" . $table . "'>" . $table . "</option>";
                        }
                        ?>
                    </select>

                </div>
                <div class='field'>

                    <label><?php echo nm_get_text_lang("['app_name']"); ?></label>


                    <select name='app[app_name]' class='select_fields search ui fluid dropdown selection'>

                    </select>

                </div>
            </div>
            <div class="fields two">
                <div class='field'>

                    <label><?php echo nm_get_text_lang("['desc']"); ?></label>


                    <select name='app[description]' class='select_fields search ui fluid dropdown selection'>

                    </select>

                </div>
                <div class='field'>

                    <label><?php echo nm_get_text_lang("['app_type']"); ?></label>


                    <select name='app[app_type]' class='select_fields search ui fluid dropdown selection'>

                    </select>

                </div>
            </div>
        </div>
    </div>
</div>
<div class="ui bottom attached tab segment" data-tab="grp" id="grp">
    <div class="ui">
        <div class="ui form">
            <div class="fields two">
                <div class='field'>

                    <label><?php echo nm_get_text_lang("['table']"); ?></label>


                    <select class='select_tables search ui fluid dropdown selection' name="grp[table]"
                            onChange="ajaxGetFields(this.value, 'grp');">
                        <option value=""></option>
                        <?php
                        foreach ($arr_tables as $table) {
                            echo "<option value='" . $table . "'>" . $table . "</option>";
                        }
                        ?>
                    </select>

                </div>
                <div class='field'>

                    <label><?php echo nm_get_text_lang("['id']"); ?></label>


                    <select name='grp[group_id]' class='select_fields search ui fluid dropdown selection'>

                    </select>

                </div>
            </div>
            <div class="fields two">
                <div class='field'>

                    <label><?php echo nm_get_text_lang("['desc']"); ?></label>


                    <select name='grp[description]' class='select_fields search ui fluid dropdown selection'>

                    </select>

                </div>
            </div>

        </div>
    </div>
</div>
<div class="ui bottom attached tab segment" data-tab="usr_grp" id="usr_grp">
    <div class="ui">
        <div class="ui form">
            <div class="fields two">
                <div class='field'>

                    <label><?php echo nm_get_text_lang("['table']"); ?></label>


                    <select class='select_tables search ui fluid dropdown selection' name="usr_grp[table]"
                            onChange="ajaxGetFields(this.value, 'usr_grp');">
                        <option value=""></option>
                        <?php
                        foreach ($arr_tables as $table) {
                            echo "<option value='" . $table . "'>" . $table . "</option>";
                        }
                        ?>
                    </select>

                </div>
                <div class='field'>

                    <label><?php echo nm_get_text_lang("['login']"); ?></label>


                    <select name='usr_grp[login]' class='select_fields search ui fluid dropdown selection'>

                    </select>

                </div>
            </div>
            <div class="fields two">
                <div class='field'>

                    <label><?php echo nm_get_text_lang("['grp_id']"); ?></label>


                    <select name='usr_grp[group_id]' class='select_fields search ui fluid dropdown selection'>

                    </select>

                </div>
            </div>

        </div>
    </div>
</div>
<div class="ui bottom attached tab segment" data-tab="grp_app" id="grp_app">
    <div class="ui">
        <div class="ui form">
            <div class="fields two">
                <div class='field'>

                    <label><?php echo nm_get_text_lang("['table']"); ?></label>


                    <select class='select_tables search ui fluid dropdown selection' name="grp_app[table]"
                            onChange="ajaxGetFields(this.value, 'grp_app');">
                        <option value=""></option>
                        <?php
                        foreach ($arr_tables as $table) {
                            echo "<option value='" . $table . "'>" . $table . "</option>";
                        }
                        ?>
                    </select>

                </div>
                <div class='field'>

                    <label><?php echo nm_get_text_lang("['grp_id']"); ?></label>


                    <select name='grp_app[group_id]' class='select_fields search ui fluid dropdown selection'>

                    </select>

                </div>
            </div>
            <div class="fields two">
                <div class='field'>

                    <label><?php echo nm_get_text_lang("['app_name']"); ?></label>


                    <select name='grp_app[app_name]' class='select_fields search ui fluid dropdown selection'>

                    </select>

                </div>
                <div class='field'>

                    <label><?php echo nm_get_text_lang("['access_priv']"); ?></label>


                    <select name='grp_app[priv_access]' class='select_fields search ui fluid dropdown selection'>

                    </select>

                </div>
            </div>
            <div class="fields two">
                <div class='field'>

                    <label><?php echo nm_get_text_lang("['insert_priv']"); ?></label>


                    <select name='grp_app[priv_insert]' class='select_fields search ui fluid dropdown selection'>

                    </select>

                </div>
                <div class='field'>

                    <label><?php echo nm_get_text_lang("['del_priv']"); ?></label>


                    <select name='grp_app[priv_delete]' class='select_fields search ui fluid dropdown selection'>

                    </select>

                </div>
            </div>
            <div class="fields two">
                <div class='field'>

                    <label><?php echo nm_get_text_lang("['upd_priv']"); ?></label>


                    <select name='grp_app[priv_update]' class='select_fields search ui fluid dropdown selection'>

                    </select>

                </div>
                <div class='field'>

                    <label><?php echo nm_get_text_lang("['exp_priv']"); ?></label>


                    <select name='grp_app[priv_export]' class='select_fields search ui fluid dropdown selection'>

                    </select>

                </div>
            </div>
            <div class="fields two">
                <div class='field'>

                    <label><?php echo nm_get_text_lang("['print_priv']"); ?></label>


                    <select name='grp_app[priv_print]' class='select_fields search ui fluid dropdown selection'>

                    </select>

                </div>
            </div>


        </div>
    </div>
</div>
<div class="ui bottom attached tab segment" data-tab="usr_app" id="usr_app">
    <div class="ui">
        <div class="ui form">
            <div class="fields two">
                <div class='field'>

                    <label><?php echo nm_get_text_lang("['table']"); ?></label>


                    <select class='select_tables search ui fluid dropdown selection' name="usr_app[table]"
                            onChange="ajaxGetFields(this.value, 'usr_app');">
                        <option value=""></option>
                        <?php
                        foreach ($arr_tables as $table) {
                            echo "<option value='" . $table . "'>" . $table . "</option>";
                        }
                        ?>
                    </select>

                </div>
                <div class='field'>

                    <label><?php echo nm_get_text_lang("['login']"); ?></label>


                    <select name='usr_app[login]' class='select_fields search ui fluid dropdown selection'>

                    </select>

                </div>
            </div>
            <div class="fields two">
                <div class='field'>

                    <label><?php echo nm_get_text_lang("['app_name']"); ?></label>


                    <select name='usr_app[app_name]' class='select_fields search ui fluid dropdown selection'>

                    </select>

                </div>
                <div class='field'>

                    <label><?php echo nm_get_text_lang("['access_priv']"); ?></label>


                    <select name='usr_app[priv_access]' class='select_fields search ui fluid dropdown selection'>

                    </select>

                </div>
            </div>
            <div class="fields two">
                <div class='field'>

                    <label><?php echo nm_get_text_lang("['insert_priv']"); ?></label>


                    <select name='usr_app[priv_insert]' class='select_fields search ui fluid dropdown selection'>

                    </select>

                </div>
                <div class='field'>

                    <label><?php echo nm_get_text_lang("['del_priv']"); ?></label>


                    <select name='usr_app[priv_delete]' class='select_fields search ui fluid dropdown selection'>

                    </select>

                </div>
            </div>
            <div class="fields two">
                <div class='field'>

                    <label><?php echo nm_get_text_lang("['upd_priv']"); ?></label>


                    <select name='usr_app[priv_update]' class='select_fields search ui fluid dropdown selection'>

                    </select>

                </div>
                <div class='field'>

                    <label><?php echo nm_get_text_lang("['exp_priv']"); ?></label>


                    <select name='usr_app[priv_export]' class='select_fields search ui fluid dropdown selection'>

                    </select>

                </div>
            </div>
            <div class="fields two">
                <div class='field'>

                    <label><?php echo nm_get_text_lang("['print_priv']"); ?></label>


                    <select name='usr_app[priv_print]' class='select_fields search ui fluid dropdown selection'>

                    </select>

                </div>
            </div>


        </div>
    </div>
</div>
<?php if ($_SESSION['nm_session']['module_security']['profile']['tabela_logged'] == 'S'): ?>

    <div class="ui bottom attached tab segment" data-tab="logged" id="logged">
        <div class="ui">
            <div class="ui form">
                <div class="fields two">
                    <div class='field'>

                        <label><?php echo nm_get_text_lang("['table']"); ?></label>


                        <select class='select_tables search ui fluid dropdown selection' name="logged[table]"
                                onChange="ajaxGetFields(this.value, 'logged');">
                            <option value=""></option>
                            <?php
                            foreach ($arr_tables as $table) {
                                echo "<option value='" . $table . "'>" . $table . "</option>";
                            }
                            ?>
                        </select>

                    </div>
                    <div class='field'>

                        <label><?php echo nm_get_text_lang("['login']"); ?></label>


                        <select name='logged[login]' class='select_fields search ui fluid dropdown selection'>

                        </select>

                    </div>
                </div>
                <div class="fields two">
                    <div class='field'>

                        <label><?php echo nm_get_text_lang("['date_login']"); ?></label>


                        <select name='logged[date_login]' class='select_fields search ui fluid dropdown selection'>

                        </select>

                    </div>
                    <div class='field'>

                        <label><?php echo nm_get_text_lang("['session']"); ?></label>


                        <select name='logged[sc_session]' class='select_fields search ui fluid dropdown selection'>

                        </select>

                    </div>
                </div>
                <div class="fields two">
                    <div class='field'>

                        <label><?php echo nm_get_text_lang("['ip']"); ?></label>


                        <select name='logged[ip]' class='select_fields search ui fluid dropdown selection'>

                        </select>

                    </div>
                </div>

            </div>
        </div>
    </div>
<?php endif; ?>

<?php if ($_SESSION['nm_session']['module_security']['profile']['tabela_social'] == 'S'): ?>
    <div class="ui bottom attached tab segment" data-tab="social" id="social">
        <div class="ui">
            <div class="ui form">
                <div class="fields two">
                    <div class='field'>

                        <label><?php echo nm_get_text_lang("['table']"); ?></label>


                        <select class='select_tables search ui fluid dropdown selection' name="usr_social[table]"
                                onChange="ajaxGetFields(this.value, 'social');">
                            <option value=""></option>
                            <?php
                            foreach ($arr_tables as $table) {
                                echo "<option value='" . $table . "'>" . $table . "</option>";
                            }
                            ?>
                        </select>

                    </div>
                    <div class='field'>

                        <label><?php echo nm_get_text_lang("['login']"); ?></label>


                        <select name='usr_social[login]' class='select_fields search ui fluid dropdown selection'>

                        </select>

                    </div>
                </div>
                <div class="fields two">
                    <div class='field'>

                        <label><?php echo nm_get_text_lang("['resource']"); ?></label>


                        <select name='usr_social[resource]' class='select_fields search ui fluid dropdown selection'>

                        </select>

                    </div>
                    <div class='field'>

                        <label><?php echo nm_get_text_lang("['resource_id']"); ?></label>


                        <select name='usr_social[resource_id]' class='select_fields search ui fluid dropdown selection'>

                        </select>

                    </div>
                </div>

            </div>
        </div>
    </div>
<?php endif; ?>
<div class="ui bottom attached tab segment" data-tab="settings" id="settings">
    <div class="ui">
        <div class="ui form">
            <div class="fields two">
                <div class='field'>

                    <label><?php echo nm_get_text_lang("['table']"); ?></label>


                    <select class='select_tables search ui fluid dropdown selection' name="settings[table]"
                            onChange="ajaxGetFields(this.value, 'settings');">
                        <option value=""></option>
                        <?php
                        foreach ($arr_tables as $table) {
                            echo "<option value='" . $table . "'>" . $table . "</option>";
                        }
                        ?>
                    </select>

                </div>
                <div class='field'>

                    <label><?php echo nm_get_text_lang("['set_name']"); ?></label>


                    <select name='settings[set_name]' class='select_fields search ui fluid dropdown selection'>

                    </select>

                </div>
            </div>
            <div class="fields two">
                <div class='field'>

                    <label><?php echo nm_get_text_lang("['set_value']"); ?></label>


                    <select name='settings[set_value]' class='select_fields search ui fluid dropdown selection'>

                    </select>

                </div>
            </div>

        </div>
    </div>
</div>

